// MDD Exporter.js
//
// this is tool script to export .mdd file data of selected polygon object.
// place it into ~/Library/Application Support/Cheetah3D/scripts/Tool folder.
//
// v.20101016 first.
// v.20101017 zup/yup option added.
// v.20101018 flip bug fixed.
// v.20120828 fix crash bug for v601
//
// Hiroto Tsubaki - tg@tres-graficos.jp

var file;

function buildUI( tool ) {
	
	var doc = tool.document();
	
	tool.addParameterSeparator("Bake");
	tool.addParameterBool("bake modifiers", 1, 0, 1, false, false);
	tool.addParameterSelector("bake transform", ['none', 'obj', 'obj2world'], false, false);
	//tool.addParameterInt("bake transform", 0, 0, 2, false, false);

	tool.addParameterSeparator("Animation");
	tool.addParameterInt("fps", 30, 1, 1000, false, false);
	tool.addParameterFloat("start time", 0, 0, 100000, false, false);
	tool.addParameterFloat("end time", 4, 0, doc.animationEnd(), false, false);
	
	tool.addParameterSeparator("Export");
	tool.addParameterSelector("coordinate system", [ "zup", "yup" ], false, false);
  //tool.addParameterInt("coordinate system", 0, 0, 1, false, false);
  
	tool.addParameterBool("export base .obj", 1, 0, 1, false, false );
	tool.addParameterButton( 'export', 'export', 'exportMDD' );
}

function exportMDD( tool ) {
	
	var doc = tool.document();
	
	var obj = doc.selectedObject();
	if (obj.family() != NGONFAMILY) {
		OS.beep();
		OS.messageBox( "Object Selection Error", "You have to select polygon object to export." );
		return;
	}
	var core;
	if (tool.getParameter("bake modifiers")) {
		core = obj.modCore();
	} else {
		core = obj.core();
	}
	
	var mat_type = parseInt( tool.getParameter("bake transform") );
	var mat = new Mat4D();
	
	var b_mat;
	switch ( parseInt( tool.getParameter("coordinate system") ) ) {
		case 0:
			b_mat = new Mat4D();
			b_mat.m22 = -1;
			
			break;
		case 1:
			var i_mat = new Mat4D();
			i_mat.m11 = -1;
			
			b_mat = new Mat4D(ROTATE, 90, 0, 0);
			b_mat = i_mat.multiply( b_mat );
			break;
	}
	
	var fps = tool.getParameter("fps");
	var time_s = tool.getParameter("start time");
	var time_e = tool.getParameter("end time");
	if (time_e > doc.animationEnd()) time_e = doc.animationEnd();
	
	var dt = 1/fps;
	
	var total_frames = parseInt( (time_e - time_s) / dt ) + 1; // 0 start? or 1 start?
	//
	var total_points = core.vertexCount();
	//
	var path = OS.runSavePanel('mdd');
	if ( path == null ) return;
	
	file = new File( path );
	
	var lpc = file.lastPathComponent();
	var dir = file.directory();
	
	var objpath = dir + "/" + ( lpc.replace(/\.mdd$/, ".obj") );
	var mtlpath = dir + "/" + ( lpc.replace(/\.mdd$/, ".mtl") );
	
	if (tool.getParameter("export base .obj")) {
		doc.saveToFile( objpath, "obj" );
		doc.saveToFile( mtlpath, "mtl" );
	}
	
	file.open( WRITE_MODE, BIG_ENDIAN );
	// write head
	file.writeInt( parseInt(total_frames) );
	file.writeInt( parseInt(total_points) );
	for (i = 0;i < total_frames;i++) {
		file.writeFloat( parseFloat(dt) ); 
	}
	
	print('total_frames:'+total_frames);
	print('total_points:'+total_points);
	//
	var vec;
	var i, ti;
	for (ti = 0;ti < total_frames;ti++) {
		
		doc.setAnimPosition( time_s );
		time_s += dt;
		
		switch( mat_type ) {
			case 0:
				break;
			case 1:
				mat = obj.objMatrix();
				break;
			case 2:
				mat = obj.obj2WorldMatrix();
				break;
		}
		
		for ( i = 0;i < total_points;i++ ) {
			vec = b_mat.multiply( mat.multiply( core.vertex( i ) ) );
			
			file.writeFloat( vec.x );
			file.writeFloat( vec.y );
			file.writeFloat( vec.z );
		}
	}
	
	file.close();
}

